/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.tags.hmc;

import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagSupport;

public class HMCContextHandler
extends TagSupport {
    private static final String TRACE_MASKT = "XTGHCTXT";
    private static final String CLASS_NAME = "[HMCContextHandler] ";
    private static final String DATA_BEAN = "databean";
    private static final String PANEL_MODEL = "panelModel";
    private static final String TOP_PANEL_MODEL = "topPanelModel";
    private static final String PANEL_MODEL_STACK = "panelModelStack";
    private String modelid;

    public HMCContextHandler() {
        Trace.trace(TRACE_MASKT, "[HMCContextHandler] <> HMCContextHandler()");
    }

    public int doStartTag() {
        Trace.trace(TRACE_MASKT, "[HMCContextHandler] -> doStartTag()");
        this.pushPanelModel();
        this.setActivePanelModel(this.findPanelModel());
        Trace.trace(TRACE_MASKT, "[HMCContextHandler] <- doStartTag()");
        return 1;
    }

    public int doEndTag() {
        Trace.trace(TRACE_MASKT, "[HMCContextHandler] -> doEndTag()");
        this.setActivePanelModel(this.popPanelModel());
        Trace.trace(TRACE_MASKT, "[HMCContextHandler] <- doEndTag()");
        return 6;
    }

    public void setModelID(String modelid) {
        Trace.trace(TRACE_MASKT, "[HMCContextHandler] -> setModelID() : " + modelid);
        if (modelid == null) {
            Trace.trace(TRACE_MASKT, "[HMCContextHandler]    Error: modelID is null");
            throw new IllegalArgumentException("modelID is null");
        }
        this.modelid = modelid;
        Trace.trace(TRACE_MASKT, "[HMCContextHandler] <- setModelID()");
    }

    private PanelModel findPanelModel() {
        return PanelModel.getPanelModelRegistry().getModel(this.modelid);
    }

    private void setActivePanelModel(PanelModel model) {
        if (model == null) {
            this.pageContext.removeAttribute(PANEL_MODEL);
            this.pageContext.removeAttribute(DATA_BEAN);
        } else {
            this.pageContext.setAttribute(PANEL_MODEL, (Object)model);
            this.pageContext.setAttribute(DATA_BEAN, (Object)model.getDataBean());
            PanelModel topModel = (PanelModel)this.pageContext.getAttribute(TOP_PANEL_MODEL);
            if (topModel == null) {
                this.pageContext.setAttribute(TOP_PANEL_MODEL, (Object)model);
            }
        }
    }

    private PanelModel getActivePanelModel() {
        PanelModel model = (PanelModel)this.pageContext.getAttribute(PANEL_MODEL);
        return model;
    }

    private void pushPanelModel() {
        PanelModel model;
        Stack<PanelModel> stack = (Stack<PanelModel>)this.pageContext.getAttribute(PANEL_MODEL_STACK);
        if (stack == null) {
            stack = new Stack<PanelModel>();
            this.pageContext.setAttribute(PANEL_MODEL_STACK, stack);
        }
        if ((model = this.getActivePanelModel()) != null) {
            stack.push(model);
        }
    }

    private PanelModel popPanelModel() {
        Stack stack = (Stack)this.pageContext.getAttribute(PANEL_MODEL_STACK);
        if (stack == null) {
            Trace.trace(TRACE_MASKT, "[HMCContextHandler]    Error: Panel Model Stack does not exist");
            throw new IllegalStateException("Panel Model Stack does not exist");
        }
        PanelModel model = stack.empty() ? null : (PanelModel)stack.pop();
        return model;
    }
}

